


# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")

# source and generate data
source("generate.R")

# 
p <- ggplot(email,aes(x=Time,y=responseTime)) + geom_point() + xlim(0,5) +
  stat_smooth(method="lm",fullrange=TRUE,level=0.95) + 
  #stat_smooth(method="lm", aes(colour="lm"), se=FALSE ,fullrange=TRUE, level=0.95) +
  #stat_smooth(method="rq", aes(colour="rq"), se=FALSE, fullrange=TRUE, level=0.95) +
  #stat_smooth(method="rlm", aes(colour="rlm"), se=FALSE, fullrange=TRUE, level=0.95) +
  facet_grid(~Team)

ggsave(file="model_prediction.pdf")


fit <- lm(responseTime ~ Time, data=email)
summary(fit)

